
graphicLevel = 2;
activeView = "master";
element = null;
schema = null;
graphicContext = null;

function init(inElement) {
    
    graphicContext = window.parent.frames[1].getGraphicContext();
    displayGraphicContext();
    
    element = inElement;
    document.getElementById("graphicLevel").innerHTML = graphicLevel;
    /*displayXSDGraphic(inElement, graphicContext);*/
    
    if (graphicContext != null)
        displayXSDDivFlat(graphicLevel, graphicContext);
            else
        displayXSDDiv(graphicLevel);
}

function levelSet(level, inElement) {
    if (level < 1) {
        level = 1;
    }
    if (level > 4) {
        level = 4;
    }
    graphicLevel = level;
    document.getElementById("graphicLevel").innerHTML = graphicLevel;
    return(graphicLevel);
}

function displayXSDDiv(level){ 
        hide(document.getElementsByClassName('diagram'));
        show(document.getElementById('level'+level));
}

function displayXSDDivFlat(level, schema){
        hide(document.getElementsByClassName('diagram'));
        var graphicDivFlat = document.getElementById('level'+level+schema);
        if (graphicDivFlat != null)
        show(document.getElementById('level'+level+schema));    
        else
        show(document.getElementById('level'+level));
        }

function hide (elements) {
  elements = elements.length ? elements : [elements];
  for (var index = 0; index < elements.length; index++) {
    elements[index].style.display = 'none';
  }
}

function show (elements, specifiedDisplay) {
  elements = elements.length ? elements : [elements];
  for (var index = 0; index < elements.length; index++) {
    elements[index].style.display = specifiedDisplay || 'block';
  }
}

function displayGraphicContext () {
    if (graphicContext != null)
    document.getElementById("graphicContext").innerHTML = "Context of: " + graphicContext; else
    document.getElementById("graphicContext").innerHTML = " ";
}

function changeLevel(changeValue) {
   levelSet(graphicLevel + changeValue);
    var graphicContext = window.parent.frames[1].getGraphicContext();
    
    if (graphicContext != null)
    activeView = "flat";
    else
    activeView = "master";
    console.log(graphicContext);
    console.log(activeView);
    
    if (activeView == "master")
    displayXSDDiv(graphicLevel);
    
    if (activeView == "flat")
    displayXSDDivFlat(graphicLevel, graphicContext);
}

function loadXMLDoc(dname) {
    xhttp = new XMLHttpRequest();
    //if (xhttp.overrideMimeType)  xhttp.overrideMimeType("text/xml");
    xhttp.open("GET", dname, false);
    xhttp.send("");
    return xhttp.responseXML;
}

function displayXSDGraphic(startElement, context) {
    activeView = "master";
    
    if (context == null) {
        graphicContext = null;
        displayGraphicContext();
        window.parent.frames[1].setGraphicContext(null);        
        displayXSDDiv(graphicLevel, schema);
    }
    
    if (graphicContext != null) {
    displayXSDGraphicFlat(startElement, graphicContext);    
    }  
    return null;
}

function resizeIFrameToFitContent( iFrame ) {

    iFrame.width  = iFrame.contentWindow.document.body.scrollWidth;
    iFrame.height = iFrame.contentWindow.document.body.scrollHeight;
}


function displayXSDGraphicFlat(startElement, schemaFile) {
    activeView = "flat";    
    graphicContext = schemaFile;
    displayGraphicContext();
    window.parent.frames[1].setGraphicContext(schemaFile);    
    schema = schemaFile;   
    displayXSDDivFlat(graphicLevel, schema);    
    return null;
}
