<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:math="http://www.w3.org/2005/xpath-functions/math"
    exclude-result-prefixes="xs math"
    version="3.0">
    <xsl:param name="mappingsFile">
        <xsl:copy-of select="document('file:///j:/S1000D/projects/data_dictionaries/actual_work/data_dictionary_60-000_01/Files/xsl/dmc-mapping_SFU.xml')/." />
    </xsl:param>
    
    <xsl:param name="mappings">
        <xsl:apply-templates select="$mappingsFile"/>    
    </xsl:param>
    
    <xsl:template match="mapping" >
        <xsl:copy>
            <xsl:attribute name="from" select="concat('DMC-',@current_chapter_DMC)" />
            <xsl:attribute name="to">
                <xsl:value-of select="concat('DMC-',@MODELLIC, '-', @SDC, '-', @SYSTEM, '-', @SUB, @SUB-SUB, '-', @ASSY, '-', @DISASS, @DISCODEV, '-', @INCODE_V, '-', @ILC)"/>
            </xsl:attribute>
        </xsl:copy>
    </xsl:template>
    
    <xsl:template match="/" >
        <xsl:copy>
            <xsl:apply-templates select="@* | node()" />
        </xsl:copy>
    </xsl:template>
        
    <xsl:template match="@* | node()" >
        <xsl:copy>
            <xsl:apply-templates select="@* | node()" />
        </xsl:copy>
    </xsl:template>
    <xsl:template match="DMC">
        <xsl:param name="dmc" select="substring(.,1,34)" />
        <DMC>            
            <xsl:choose>
                <xsl:when test="$mappings//mapping[@from=$dmc]">
                    <xsl:value-of select="$mappings//mapping[@from=$dmc][1]/@to" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="." />
                </xsl:otherwise>
            </xsl:choose>
        </DMC>
    </xsl:template>
</xsl:stylesheet>