<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    exclude-result-prefixes="xs"
    version="2.0">
    
    <xsl:template match="xs:simpleType" mode="definitionDisplay">
        <xsl:text>&lt;xs:simpleType </xsl:text>
        <xsl:text>name="</xsl:text>
        <xsl:value-of select="@name"/>
        <xsl:text>"</xsl:text>
        <xsl:text>&gt;</xsl:text>
        <div class="definitionDisplay">
            <xsl:apply-templates mode="definitionDisplay"/>
        </div>
        <xsl:text>&lt;/xs:simpleType&gt;</xsl:text>
    </xsl:template>
    
    <xsl:template match="xs:sequence" mode="definitionDisplay">
        <div style="font-family:Courier New;">
            <xsl:text>&lt;xs:sequence</xsl:text>
            <xsl:if test="@minOccurs">
                <xsl:text> minOccurs="</xsl:text>
                <xsl:value-of select="@minOccurs"/>
                <xsl:text>"</xsl:text>
            </xsl:if>
            <xsl:if test="@maxOccurs">
                <xsl:text> maxOccurs="</xsl:text>
                <xsl:value-of select="@maxOccurs"/>
                <xsl:text>"</xsl:text>
            </xsl:if>
            <xsl:text>&gt;</xsl:text>
            <div class="definitionDisplay">
                <xsl:apply-templates mode="definitionDisplay"/>
            </div>
            <xsl:text>&lt;/xs:sequence&gt;</xsl:text>
        </div>
    </xsl:template>
    
    <xsl:template match="xs:choice" mode="definitionDisplay">
        <div style="font-family:Courier New;">
            <xsl:text>&lt;xs:choice</xsl:text>
            <xsl:if test="@minOccurs">
                <xsl:text> minOccurs="</xsl:text>
                <xsl:value-of select="@minOccurs"/>
                <xsl:text>"</xsl:text>
            </xsl:if>
            <xsl:if test="@maxOccurs">
                <xsl:text> maxOccurs="</xsl:text>
                <xsl:value-of select="@maxOccurs"/>
                <xsl:text>"</xsl:text>
            </xsl:if>
            <xsl:text>&gt;</xsl:text>
            <div class="definitionDisplay">
                <xsl:apply-templates mode="definitionDisplay"/>
            </div>
            <xsl:text>&lt;/xs:choice&gt;</xsl:text>
        </div>
    </xsl:template>
    
    <xsl:template match="xs:element" mode="definitionDisplay">
        <div class="definitionDisplay">
            <xsl:text>&lt;xs:element </xsl:text>
            <xsl:text>ref="</xsl:text>
            <xsl:value-of select="@ref"/>
            <xsl:text>"</xsl:text>
            <xsl:if test="@minOccurs">
                <xsl:text> minOccurs="</xsl:text>
                <xsl:value-of select="@minOccurs"/>
                <xsl:text>"</xsl:text>
            </xsl:if>
            <xsl:if test="@maxOccurs">
                <xsl:text> maxOccurs="</xsl:text>
                <xsl:value-of select="@maxOccurs"/>
                <xsl:text>"</xsl:text>
            </xsl:if>
            <xsl:text>/&gt;</xsl:text>
        </div>
    </xsl:template>
    
    <xsl:template match="xs:group" mode="definitionDisplay">
        <xsl:text>&lt;xs:group </xsl:text>
        <xsl:choose>
            <xsl:when test="@ref">
                <xsl:text>ref="</xsl:text>
                <xsl:value-of select="@ref"/>
                <xsl:text>"</xsl:text>
                
                <xsl:if test="@minOccurs">
                    <xsl:text> minOccurs="</xsl:text>
                    <xsl:value-of select="@minOccurs"/>
                    <xsl:text>"</xsl:text>
                </xsl:if>
                <xsl:if test="@maxOccurs">
                    <xsl:text> maxOccurs="</xsl:text>
                    <xsl:value-of select="@maxOccurs"/>
                    <xsl:text>"</xsl:text>
                </xsl:if>
                <xsl:text>/&gt;</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>name="</xsl:text>
                <xsl:value-of select="@name"/>
                <xsl:text>"</xsl:text>
                <xsl:text>&gt;</xsl:text>
                <xsl:apply-templates mode="definitionDisplay"/>
                <xsl:text>&lt;/xs:group&gt;</xsl:text>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="xs:attribute" mode="definitionDisplay">
        <div class="definitionDisplay">
            <xsl:text>&lt;xs:attribute </xsl:text>
            <xsl:text>ref="</xsl:text>
            <xsl:value-of select="@ref"/>
            <xsl:text>"</xsl:text>
            <xsl:if test="@use">
                <xsl:text> use="</xsl:text>
                <xsl:value-of select="@use"/>
                <xsl:text>"</xsl:text>
            </xsl:if>
            <xsl:if test="@default">
                <xsl:text> default="</xsl:text>
                <xsl:value-of select="@default"/>
                <xsl:text>"</xsl:text>
            </xsl:if>
            <xsl:text>/&gt;</xsl:text>
        </div>
    </xsl:template>
    
    <xsl:template match="xs:attributeGroup" mode="definitionDisplay">
        <div class="definitionDisplay">
            <xsl:text>&lt;xs:attributeGroup </xsl:text>
            <xsl:choose>
                <xsl:when test="@ref">
                    <xsl:text>ref="</xsl:text>
                    <xsl:value-of select="@ref"/>
                    <xsl:text>"</xsl:text>
                    <xsl:text>/&gt;</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>name="</xsl:text>
                    <xsl:value-of select="@name"/>
                    <xsl:text>"</xsl:text>
                    <xsl:text>&gt;</xsl:text>
                    <xsl:apply-templates/>
                    <xsl:text>&lt;/xs:attributeGroup&gt;</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>
    
    <xsl:template match="xs:restriction" mode="definitionDisplay">
        <xsl:text>&lt;xs:restriction </xsl:text>
        <xsl:text>base="</xsl:text>
        <xsl:value-of select="@base"/>
        <xsl:text>"</xsl:text>
        <xsl:text>&gt;</xsl:text>
        
        <div class="definitionDisplay">
            <xsl:apply-templates/>
        </div>
        <xsl:text>&lt;/xs:restriction&gt;</xsl:text>
    </xsl:template>
    
    <xsl:template match="xs:enumeration" mode="definitionDisplay">
        <div class="definitionDisplayStyle">
            <xsl:text>&lt;xs:enumeration </xsl:text>
            <xsl:text>value="</xsl:text>
            <xsl:value-of select="@value"/>
            <xsl:text>"</xsl:text>
            <xsl:text>/&gt;</xsl:text>
        </div>
    </xsl:template>
    
    <xsl:template match="xs:pattern" mode="definitionDisplay">	
        <div class="definitionDisplayStyle">
            <xsl:text>&lt;xs:pattern </xsl:text>
            <xsl:text>value="</xsl:text>
            <xsl:value-of select="@value"/>
            <xsl:text>"</xsl:text>
            <xsl:text>/&gt;</xsl:text>
        </div>
    </xsl:template>
    
    <xsl:template match="xs:totalDigits" mode="definitionDisplay">
        <xsl:text>&lt;xs:totalDigits </xsl:text>
        <xsl:text>value="</xsl:text>
        <xsl:value-of select="@value"/>
        <xsl:text>"</xsl:text>
        <xsl:text>/&gt;</xsl:text>
        <xsl:if test="@fixed">
            <xsl:text> fixed="</xsl:text>
            <xsl:value-of select="@fixed"/>
            <xsl:text>"</xsl:text>
        </xsl:if>
        <xsl:text>/&gt;</xsl:text>
    </xsl:template>
</xsl:stylesheet>